#ifndef LOCAL
#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx,avx2")
#else
#define _GLIBCXX_DEBUG
#endif

#include <bits/stdc++.h>
using namespace std;

template<typename T>
istream& operator>>(istream& in, vector<T>& v) {
    for (T& x : v) in >> x;
    return in;
}
template<typename T>
ostream& operator<<(ostream& out, const vector<T>& v) {
    for (T x : v) out << x << " ";
    return out;
}

#define all() (v).begin(), (v).end()
#define rall() (v).rbegin(), (v).rend()
using ll = long long;
using ld = long double;

const ll MOD = 998244353;

ll binpow(ll a, ll b) {
    if (b == 0) return 1;
    if (b & 1) return binpow(a, b - 1) * a % MOD;
    ll t = binpow(a, b / 2);
    return t * t % MOD;
}

ll rev(ll n) {
    return binpow(n, MOD - 2);
}

void solve() {

    ll n, m;
    cin >> n >> m;

    if (m == 1) {
        cout << n << "\n";
        return;
    }

    ll ans = 0;
    for (int l = 1; l <= n; l++) {
        vector<ll> dp(n + 1), pref(n + 1);
        dp[0] = pref[0] = 1;
        for (int i = 1; i <= n; i++) {
            dp[i] = (pref[i - 1] - (i >= l + 1 ? pref[i - l - 1] : 0)) * (m - 1) % MOD;
            pref[i] = (pref[i - 1] + dp[i]) % MOD;
        }
        ans += dp[n] * m % MOD * l % MOD;
        ans %= MOD;
    }

    cout << ans * rev(binpow(m, n)) << "\n";

}

//1 1: 0
//2 1: 0
//2 2: 24
//3 1: 0
//3 2: 24
//3 3: 18
//4 1: 0
//4 2: 36
//4 3: 12
//4 4: 6
//5 1: 48
//5 2: 48
//5 3: 18
//5 4: 6
//5 5: 3

int main() {
#ifndef LOCAL
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
#endif

    cout << setprecision(9) << fixed;

    int t;
    cin >> t;
    while (t--) solve();
    return 0;
}
